VERSION 5.00
Begin VB.Form frmMain 
   Caption         =   "Fireworks"
   ClientHeight    =   7590
   ClientLeft      =   60
   ClientTop       =   375
   ClientWidth     =   9030
   FillStyle       =   0  'Solid
   LinkTopic       =   "Form1"
   ScaleHeight     =   506
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   602
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Command1 
      Caption         =   "Launch"
      Height          =   555
      Left            =   3728
      TabIndex        =   1
      Top             =   6960
      Width           =   1575
   End
   Begin VB.PictureBox Canvas 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H00000000&
      FillStyle       =   0  'Solid
      ForeColor       =   &H80000008&
      Height          =   6615
      Left            =   360
      ScaleHeight     =   439
      ScaleMode       =   3  'Pixel
      ScaleWidth      =   552
      TabIndex        =   0
      Top             =   180
      Width           =   8310
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Private Declare Function GetTickCount Lib "kernel32.dll" () As Long
Private Declare Sub Sleep Lib "kernel32.dll" (ByVal dwMilliseconds As Long)

'Consts
Const FPS = 25

Const PI = 3.14159275180032
Const GRAVITY_CONSTANT_PER_SECOND = -500
Const GRAVITY_CONSTANT = GRAVITY_CONSTANT_PER_SECOND / FPS
Const BLIP_MASS = 0.01 'KG

Const MAX_BLIPS = 150
Const BLIP_COLOR = vbYellow
Const RANDOM_COLORS = True
Const INIT_X = 0
Const INIT_Y = 0
Const BLIP_RADIUS = 2.5 'CM/PX

Const PROPULSION_TIME_START = 0
Const PROPULSION_TIME_END = 0.04
Const PROPULSION_FRAME_START As Long = PROPULSION_TIME_START * FPS
Const PROPULSION_FRAME_END As Long = PROPULSION_TIME_END * FPS
Const PROPULSION_FORCE_PER_SECOND = 650 'N
Const PROPULSION_FORCE = 26 'PROPULSION_FORCE_PER_SECOND / FPS 'N

Const FLIGHT_TIME_START = 0.04
Const FLIGHT_TIME_END = 1.46
Const FLIGHT_FRAME_START As Long = FLIGHT_TIME_START * FPS
Const FLIGHT_FRAME_END As Long = FLIGHT_TIME_END * FPS
Const FLIGHT_FORCE_PER_SECOND = 5  'N
Const FLIGHT_FORCE = FLIGHT_FORCE_PER_SECOND / FPS 'N

Const EXPLOSION_TIME_START = 1.5
Const EXPLOSION_TIME_END = 1.5
Const EXPLOSION_FRAME_START  As Long = EXPLOSION_TIME_START * FPS
Const EXPLOSION_FRAME_END As Long = EXPLOSION_TIME_END * FPS
Const EXPLOSION_FORCE_MIN_PER_SECOND = 150 'N
Const EXPLOSION_FORCE_MIN = EXPLOSION_FORCE_MIN_PER_SECOND / FPS 'N
Const EXPLOSION_FORCE_MAX_PER_SECOND = 550 'N
Const EXPLOSION_FORCE_MAX = EXPLOSION_FORCE_MAX_PER_SECOND / FPS 'N

Const FADE_TIME = 2.4
Const FADE_FRAME As Long = FADE_TIME * FPS

Private Type Blip
    color As OLE_COLOR
    x As Double
    y As Double
    speedX As Double
    speedY As Double
    accelerationX As Double
    accelerationY As Double
    radius As Double
End Type

Dim Running As Boolean
Dim Blips() As Blip

Private Sub Init()
    Dim i As Long
    
    ReDim Blips(MAX_BLIPS - 1)
    For i = 0 To MAX_BLIPS - 1
        If RANDOM_COLORS Then
            Blips(i).color = RGB(128 + Int(Rnd * 128), 128 + Int(Rnd * 128), 128 + Int(Rnd * 128))
            Blips(i).color = RGB(Round(Rnd) * 255, Round(Rnd) * 255, Round(Rnd) * 255)
        Else
            Blips(i).color = BLIP_COLOR
        End If
        Blips(i).x = INIT_X '- 200 + Rnd * 400
        Blips(i).y = INIT_Y
        Blips(i).radius = BLIP_RADIUS
    Next
End Sub

Private Function VirtualToRealX(x As Double) As Double
    VirtualToRealX = x + (Canvas.ScaleWidth \ 2)
End Function

Private Function VirtualToRealY(y As Double) As Double
    VirtualToRealY = Canvas.ScaleHeight - y
End Function

Private Sub DrawBlip(b As Blip)
    Canvas.FillColor = b.color
    If b.radius < 0 Then b.radius = 0
    Canvas.Circle (VirtualToRealX(b.x), VirtualToRealY(b.y)), b.radius, 0 'b.color
End Sub

Private Sub ApplyGravity(b As Blip)
    b.accelerationY = b.accelerationY + GRAVITY_CONSTANT
End Sub

Private Sub ApplyForce(b As Blip, Frame As Long, BlipNum As Long)
    Dim Force As Double
    Dim ForceDirection As Double
    
    If Frame >= PROPULSION_FRAME_START And Frame <= PROPULSION_FRAME_END Then
        Force = PROPULSION_FORCE
        ForceDirection = PI / 2
        
        b.accelerationX = b.accelerationX + (Force * Cos(ForceDirection) / BLIP_MASS)
        b.accelerationY = b.accelerationY + (Force * Sin(ForceDirection) / BLIP_MASS)
    ElseIf Frame >= FLIGHT_FRAME_START And Frame <= FLIGHT_FRAME_END Then
        Force = FLIGHT_FORCE
        ForceDirection = PI / 2
        
        b.accelerationX = b.accelerationX + (Force * Cos(ForceDirection) / BLIP_MASS)
        b.accelerationY = b.accelerationY + (Force * Sin(ForceDirection) / BLIP_MASS)
    ElseIf Frame >= EXPLOSION_FRAME_START And Frame <= EXPLOSION_FRAME_END Then
        Force = EXPLOSION_FORCE_MIN + Rnd * (EXPLOSION_FORCE_MAX - EXPLOSION_FORCE_MIN)
        ForceDirection = BlipNum * (PI * 2) / MAX_BLIPS
        'ForceDirection = Rnd * (PI * 2)
        
        b.accelerationX = b.accelerationX + (Force * Cos(ForceDirection) / BLIP_MASS)
        b.accelerationY = b.accelerationY + (Force * Sin(ForceDirection) / BLIP_MASS)
        b.speedY = b.speedY * 0.5
    End If
End Sub

Private Sub UpdatePos(b As Blip)
    b.x = b.x + b.speedX / FPS
    b.y = b.y + b.speedY / FPS
End Sub

Private Sub UpdateSpeed(b As Blip)
    b.speedX = b.speedX + b.accelerationX / FPS
    b.speedY = b.speedY + b.accelerationY / FPS
End Sub

Private Sub ClearAccel(b As Blip)
    b.accelerationX = 0
    b.accelerationY = 0
End Sub

Private Sub ApplyResistance(b As Blip)
    b.speedX = b.speedX * 0.98
    b.speedY = b.speedY * 0.98
End Sub

Private Sub Fade(b As Blip)
    Dim Red As Long, Green As Long, Blue As Long
    
    Red = b.color And &HFF
    Green = b.color \ &H100 And &HFF
    Blue = b.color \ &H10000
    If Red < 5 Then Red = 2
    If Green < 5 Then Green = 2
    If Blue < 5 Then Blue = 2
    
    b.color = RGB(Red - 2, Green - 2, Blue - 2)
    b.radius = 0.995 * b.radius - 0.02
End Sub

Private Sub AniProc()
    Dim Ticks As Long
    Dim Frame As Long
    Dim i As Long
    Dim DoRender As Boolean

    Do While Running
        Ticks = GetTickCount
        DoEvents
        Canvas.Cls
        
        DoRender = False
        For i = 0 To MAX_BLIPS - 1
            Call ClearAccel(Blips(i))
            
            Call ApplyGravity(Blips(i))
            Call ApplyForce(Blips(i), Frame, i)
            Call ApplyResistance(Blips(i))
            
            Call UpdatePos(Blips(i))
            Call UpdateSpeed(Blips(i))
            
            If Frame >= FADE_FRAME Then Call Fade(Blips(i))
            Call DrawBlip(Blips(i))
            
            If Blips(i).radius >= 0 And Blips(i).y >= 0 Then DoRender = True
        Next
        
        Frame = Frame + 1
        If (1000 / FPS - (GetTickCount - Ticks)) > 0 Then Sleep (1000 / FPS - (GetTickCount - Ticks))
        If Not DoRender Then Exit Sub
    Loop
End Sub

Private Sub Command1_Click()
    Randomize
    Init
    Running = True
    AniProc
End Sub

Private Sub Form_Terminate()
    Running = False
    Unload Me
    End
End Sub

Private Sub Form_Unload(Cancel As Integer)
    Running = False
    Unload Me
    End
End Sub
